/* 
 * File:   ImageWriter.hpp
 * Author: yuri
 *
 * Created on June 6, 2011, 2:59 PM
 */

#ifndef IMAGEWRITER_HPP
#define	IMAGEWRITER_HPP

#include <sstream>
#include <vector>
#include "afmm/include/field.h"
#include "Triple.hpp"
#include "Node.hpp"
using namespace std;

typedef std::pair<int,int> coord2D_t;
typedef vector<coord2D_t> coord2D_list_t;
typedef Triple<int,int,int> coord3D_t;
typedef Node< coord3D_t > skel_tree_t;

class ImageWriter {
public:
    ImageWriter(const char *fname);
    void writeHeader(unsigned int, unsigned int);
    void writeLayer(FIELD<float> *skel, FIELD<float> *dt, unsigned char intensity);
    int save();
    virtual ~ImageWriter();
private:
    stringstream ofBuffer;
    ofstream of;
    const char *fname;

    skel_tree_t *traceLayer(FIELD<float> *skel, FIELD<float> *dt);
    skel_tree_t *tracePath(int x, int y, FIELD<float> *skel, FIELD<float> *dt);
    coord2D_list_t *neighbours(int x, int y, FIELD<float> *skel);
    void writePath(skel_tree_t *st, int pLength, bool rightMost);
    void writeChain(coord3D_t prev, coord3D_t cur);


    /* Statistics */
    int NUMPOINTS, NUMPATHS, OLDNUMPOINTS, OLDNUMPATHS;

};


void filterTree(skel_tree_t *st);
void removeSmallPaths(skel_tree_t *st);
void removeSmallObjects(skel_tree_t *st);
#endif	/* IMAGEWRITER_HPP */

